rule Win32_Ransomware_IFN643 : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "IFN643"
        description         = "Yara rule that detects IFN643 ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "IFN643"
        tc_detection_factor = 5

    strings:

        $search_files_1 = {
            55 8B EC 6A ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 
            33 C5 89 45 ?? 53 56 57 50 8D 45 ?? 64 A3 ?? ?? ?? ?? 8B F1 89 B5 ?? ?? ?? ?? C7 45 
            ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C6 45 ?? ?? 68 ?? ?? ?? ?? 8B D6 C7 45 ?? ?? ?? 
            ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 8D 4D ?? 50 E8 ?? ?? ?? ?? 8B 85 ?? 
            ?? ?? ?? 83 F8 ?? 72 ?? 8B 8D ?? ?? ?? ?? 40 3D ?? ?? ?? ?? 72 ?? F6 C1 ?? 74 ?? E8 
            ?? ?? ?? ?? 8B 41 ?? 3B C1 72 ?? E8 ?? ?? ?? ?? 2B C8 83 F9 ?? 73 ?? E8 ?? ?? ?? ?? 
            83 F9 ?? 76 ?? E8 ?? ?? ?? ?? 8B C8 51 E8 ?? ?? ?? ?? 83 C4 ?? 83 7D ?? ?? 8D 8D ?? 
            ?? ?? ?? 8D 45 ?? 0F 43 45 ?? 51 50 FF 15 ?? ?? ?? ?? 8B D8 89 9D ?? ?? ?? ?? 83 FB 
            ?? 0F 84 
        }

        $search_files_2 = {
            80 BD ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C6 45 ?? ?? 75 ?? 33 
            C0 EB ?? 8D 85 ?? ?? ?? ?? 8D 50 ?? 8A 08 40 84 C9 75 ?? 2B C2 50 8D 85 ?? ?? ?? ?? 
            50 8D 4D ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 4D ?? F6 85 ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? 
            ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D ?? E8 
            ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B D6 8D 8D ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8D 8D ?? ?? ?? ?? C6 45 ?? ?? 51 8B D0 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 
            ?? 8B C8 C6 45 ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? 
            ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? B8 ?? ?? ?? ?? 2B 0D ?? ?? ?? ?? F7 
            E9 C1 FA ?? 8B C2 C1 E8 ?? 03 C2 83 F8 ?? 0F 83 ?? ?? ?? ?? E9 ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 85 C0 0F 8E ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B D6 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            8D 4D ?? C6 45 ?? ?? 51 8B D0 8D 4D ?? E8 ?? ?? ?? ?? 83 C4 ?? C6 45 ?? ?? 8B 85 ?? 
            ?? ?? ?? 83 F8 ?? 72 ?? 8B 8D ?? ?? ?? ?? 40 3D ?? ?? ?? ?? 72 ?? F6 C1 ?? 0F 85 ?? 
            ?? ?? ?? 8B 41 ?? 3B C1 0F 83 ?? ?? ?? ?? 2B C8 83 F9 ?? 0F 82 ?? ?? ?? ?? 83 F9 ?? 
            0F 87 ?? ?? ?? ?? 8B C8 51 E8 ?? ?? ?? ?? 83 C4 ?? 8B 0D ?? ?? ?? ?? B8 ?? ?? ?? ?? 
            8B 35 ?? ?? ?? ?? 33 DB 2B CE C7 85 ?? ?? ?? ?? ?? ?? ?? ?? F7 E9 C7 85 ?? ?? ?? ?? 
            ?? ?? ?? ?? C1 FA ?? 8B C2 C6 85 ?? ?? ?? ?? ?? C1 E8 ?? 03 C2 74 ?? 33 FF ?? ?? ?? 
            8D 45 ?? 8D 0C 37 50 E8 ?? ?? ?? ?? 85 C0 75 ?? 83 7D ?? ?? 89 45 ?? 8D 45 ?? 0F 43 
            45 ?? C6 00 ?? 8B 35 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? B8 ?? ?? ?? ?? 2B CE 43 F7 E9 83 
            C7 ?? C1 FA ?? 8B C2 C1 E8 ?? 03 C2 3B D8 72 ?? 83 7D ?? ?? 76 ?? 8D 45 ?? B9 ?? ?? 
            ?? ?? 50 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? B8 ?? ?? ?? ?? 2B 0D ?? ?? ?? ?? F7 E9 C1 
            FA ?? 8B C2 C1 E8 ?? 03 C2 83 F8 ?? 0F 83 ?? ?? ?? ?? C6 45 ?? ?? 8B 45 ?? 83 F8 ?? 
            72 ?? 8B 4D ?? 40 3D ?? ?? ?? ?? 72 ?? F6 C1 ?? 0F 85 ?? ?? ?? ?? 8B 41 ?? 3B C1 0F 
            83 ?? ?? ?? ?? 2B C8 83 F9 ?? 0F 82 ?? ?? ?? ?? 83 F9 ?? 0F 87 ?? ?? ?? ?? 8B C8 51 
            E8 ?? ?? ?? ?? 83 C4 ?? 8B 9D ?? ?? ?? ?? 8B B5 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 
            45 ?? ?? ?? ?? ?? C6 45 ?? ?? C6 45 ?? ?? 8B 45 ?? 83 F8 ?? 72 ?? 8B 4D ?? 40 3D ?? 
            ?? ?? ?? 72 ?? F6 C1 ?? 0F 85 ?? ?? ?? ?? 8B 41 ?? 3B C1 0F 83 ?? ?? ?? ?? 2B C8 83 
            F9 ?? 0F 82 ?? ?? ?? ?? 83 F9 ?? 0F 87 ?? ?? ?? ?? 8B C8 51 E8 ?? ?? ?? ?? 83 C4 ?? 
            8D 85 ?? ?? ?? ?? 50 53 FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? E9 ?? ?? ?? ?? 8B 
            45 ?? 83 F8 ?? 72 ?? 8B 4D ?? 40 3D ?? ?? ?? ?? 72 ?? F6 C1 ?? 74 ?? E8 ?? ?? ?? ?? 
            8B 41 ?? 3B C1 72 ?? E8 ?? ?? ?? ?? 2B C8 83 F9 ?? 73 ?? E8 ?? ?? ?? ?? 83 F9 ?? 76 
            ?? E8 ?? ?? ?? ?? 8B C8 51 E8 ?? ?? ?? ?? 83 C4 ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? 
            ?? ?? ?? C6 45 ?? ?? 8B 45 ?? 83 F8 ?? 72 ?? 8B 4D ?? 40 3D ?? ?? ?? ?? 72 ?? F6 C1 
            ?? 74 ?? E8 ?? ?? ?? ?? 8B 41 ?? 3B C1 72 ?? E8 ?? ?? ?? ?? 2B C8 83 F9 ?? 73 ?? E8 
            ?? ?? ?? ?? 83 F9 ?? 76 ?? E8 ?? ?? ?? ?? 8B C8 51 E8 ?? ?? ?? ?? 83 C4 ?? 8B 45 ?? 
            83 F8 ?? 72 ?? 8B 4D ?? 40 3D ?? ?? ?? ?? 72 ?? F6 C1 ?? 74 ?? E8 ?? ?? ?? ?? 8B 41 
            ?? 3B C1 72 ?? E8 ?? ?? ?? ?? 2B C8 83 F9 ?? 73 ?? E8 ?? ?? ?? ?? 83 F9 ?? 76 ?? E8 
            ?? ?? ?? ?? 8B C8 51 E8 ?? ?? ?? ?? 83 C4 ?? 8B 4D ?? 64 89 0D ?? ?? ?? ?? 59 5F 5E 
            5B 8B 4D ?? 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 
        }

        $encrypt_files = {
            55 8B EC 6A ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 83 EC ?? 53 56 57 A1 ?? ?? ?? ?? 
            33 C5 50 8D 45 ?? 64 A3 ?? ?? ?? ?? 89 65 ?? 8B C2 89 45 ?? 8B F9 8B 75 ?? 89 75 ?? 
            C7 45 ?? ?? ?? ?? ?? 90 3B F8 0F 84 ?? ?? ?? ?? 89 75 ?? C6 45 ?? ?? 85 F6 74 ?? 8B 
            17 C7 46 ?? ?? ?? ?? ?? C7 46 ?? ?? ?? ?? ?? C7 46 ?? ?? ?? ?? ?? 83 7E ?? ?? C7 46 
            ?? ?? ?? ?? ?? 72 ?? 8B 06 EB ?? 8B C6 C6 00 ?? 80 3A ?? 75 ?? 33 C0 EB ?? 8B C2 8D 
            58 ?? 66 90 8A 08 40 84 C9 75 ?? 2B C3 50 52 8B CE E8 ?? ?? ?? ?? 8B 45 ?? 83 C6 ?? 
            C6 45 ?? ?? 89 75 ?? 83 C7 ?? EB ?? 8B 55 ?? 51 8B 4D ?? E8 ?? ?? ?? ?? 83 C4 ?? 6A 
            ?? 6A ?? E8 ?? ?? ?? ?? 8B C6 8B 4D ?? 64 89 0D ?? ?? ?? ?? 59 5F 5E 5B 8B E5 5D C3 
            2B 49 ?? E9 ?? ?? ?? ?? 2B 49 ?? E9 ?? ?? ?? ?? 2B 49 ?? E9 ?? ?? ?? ?? 2B 49 ?? E9 
            ?? ?? ?? ?? 33 C0 57 8B F9 40 F0 0F C1 05 ?? ?? ?? ?? 75 ?? 56 BE ?? ?? ?? ?? 56 E8 
            ?? ?? ?? ?? 83 C6 ?? 59 81 FE ?? ?? ?? ?? 7C ?? 5E 8B C7 5F C3 
        }

    condition:
        uint16(0) == 0x5A4D and $search_files_1 and $search_files_2 and $encrypt_files

}